var TPU = window.TPU || {};

!function($, window, document)
{
	jQuery.fn.sortElementsTPU = (function(){
		var sort = [].sort;
		return function(comparator, getSortable) {
			getSortable = getSortable || function() { return this; };
			var placements = this.map(function() {
				var sortElement = getSortable.call(this),
						parentNode = sortElement.parentNode,
						// Since the element itself will change position, we have
						// to have some way of storing it's original position in
						// the DOM. The easiest way is to have a 'flag' node:
						nextSibling = parentNode.insertBefore(document.createTextNode(''), sortElement.nextSibling);

				return function() {
					if (parentNode === this) {
						throw new Error('You can\'t sort elements if any one is a descendant of another.');
					}
					// Insert before flag:
					parentNode.insertBefore(this, nextSibling);
					// Remove flag:
					parentNode.removeChild(nextSibling);
				};
			});
			return sort.call(this, comparator).each(function(i) { placements[i].call(getSortable.call(this)); });
		};
	})();

	// http://benalman.com/projects/jquery-throttle-debounce-plugin/
	// https://raw.githubusercontent.com/cowboy/jquery-throttle-debounce/v1.1/jquery.ba-throttle-debounce.js
	TPU.throttle = function( delay, no_trailing, callback, debounce_mode ) {
		// After wrapper has stopped being called, this timeout ensures that `callback` is executed at the proper times in `throttle` and `end` debounce modes.
		var timeout_id,

		// Keep track of the last time `callback` was executed.
		last_exec = 0;

		// `no_trailing` defaults to falsy.
		if ( typeof no_trailing !== 'boolean' ) {
			debounce_mode = callback;
			callback = no_trailing;
			no_trailing = undefined;
		}

		// The `wrapper` function encapsulates all of the throttling / debouncing functionality and when executed will limit the rate at which `callback` is executed.
		function wrapper() {
			var that = this;
			var elapsed = +new Date() - last_exec;
			var args = arguments;

			// Execute `callback` and update the `last_exec` timestamp.
			function exec() {
				last_exec = +new Date();
				callback.apply( that, args );
			};

			// If `debounce_mode` is true (at_begin) this is used to clear the flag to allow future `callback` executions.
			function clear() {
				timeout_id = undefined;
			};

			if ( debounce_mode && !timeout_id ) {
				// Since `wrapper` is being called for the first time and `debounce_mode` is true (at_begin), execute `callback`.
				exec();
			}

			// Clear any existing timeout.
			timeout_id && clearTimeout( timeout_id );

			if ( debounce_mode === undefined && elapsed > delay ) {
				// In throttle mode, if `delay` time has been exceeded, execute `callback`.
				exec();

			} else if ( no_trailing !== true ) {
				// In trailing throttle mode, since `delay` time has not been exceeded, schedule `callback` to execute `delay` ms after most recent execution.
				//
				// If `debounce_mode` is true (at_begin), schedule `clear` to execute after `delay` ms.
				//
				// If `debounce_mode` is false (at end), schedule `callback` to execute after `delay` ms.
				timeout_id = setTimeout( debounce_mode ? clear : exec, debounce_mode === undefined ? delay - elapsed : delay );
			}
		};

		// Set the guid of `wrapper` function to the same of original callback, so/ it can be removed in jQuery 1.4+ .unbind or .die by using the original callback as a reference.
		if ( $.guid ) {
			wrapper.guid = callback.guid = callback.guid || $.guid++;
		}

		// Return the wrapper function.
		return wrapper;
	};

	TPU.debounce = function( delay, at_begin, callback ) {
		return callback === undefined
			? TPU.throttle( delay, at_begin, false )
			: TPU.throttle( delay, callback, at_begin !== false );
	};

	TPU.Hotkey = (function(){
		var listeners = [];
		return function(key, callback) {
			var keysToCheck={ctrl:false, alt:false, shift:false, key:false, callback:callback};

			var keys=key.toLowerCase().split('+');
			$.each(keys, function(i, el) {
				if (el=='ctrl')
					keysToCheck.ctrl=true;
				else if (el=='alt')
					keysToCheck.alt=true;
				else if (el=='shift')
					keysToCheck.shift=true;
				else
					keysToCheck.key=el;
			});

			listeners.push(keysToCheck);

			// Need to add the listener only once
			if (listeners.length>1)
				return;

			$(document).on('keydown', function(e) {
				$.each(listeners, function(i, l) {
					if (e.originalEvent.altKey!=l.alt)
						return;
					if (e.originalEvent.shiftKey!=l.shift)
						return;
					if (e.originalEvent.ctrlKey!=l.ctrl)
						return;
					if (e.originalEvent.key.toLowerCase()!=l.key)
						return;

					e.stopPropagation();
					e.preventDefault();

					l.callback.apply(this, e);
				});
			});
		};
	})();
}(window.jQuery, window, document);